package com.agilex.healthcare.directscheduling.db;

import com.agilex.healthcare.directscheduling.domain.FacilityMember;
import com.agilex.healthcare.directscheduling.domain.FacilityMemberClinic;
import org.apache.commons.lang.StringUtils;

import java.sql.ResultSet;
import java.sql.SQLException;

public class PatientResultSetRowMapperClinic implements PatientResultSetRowMapper {

	private static final int LOCATION_SID_COL = 1;
	private static final int LOCATION_IEN_COL = 2;
	private static final int STA3N_COL = 3;
	private static final int LOCATION_TYPE_COL = 4;
	private static final int LOCATION_NAME_COL = 5;
	private static final int PRIM_STOP_CODE_COL = 6;
	private static final int PRIM_STOP_CODE_NAME_COL = 7;

	private static final int SEC_STOP_CODE_COL = 8;
	private static final int SEC_STOP_CODE_NAME_COL = 9;

	private static final int PHYSICAL_LOC_COL = 10;
	private static final int INSTITUTION_SID_COL = 11;
	private static final int INSTITUTION_IEN_COL = 12;
	private static final int INSTITUTION_NAME_COL = 13;
	private static final int INSTITUTION_CODE_COL = 14;
	private static final int TEAM_SID_COL = 15;
	private static final int TEAM_COL = 16;
	private static final int TEAM_PURPOSE_COL = 17;

	private static final int FRIENDLY_LOCATION_NAME_COL = 18;

	private static final int VSSC_INSTITUTION_CODE_COL = 19;
	private static final int VSSC_INSTITUTION_NAME_COL = 20;

	@Override
	public FacilityMember mapRow(ResultSet rs, int rowNum) throws SQLException {

		FacilityMemberClinic facilityMemberClinic = new FacilityMemberClinic();

		facilityMemberClinic.setTeamSID(StringUtils.trimToEmpty(rs
				.getString(TEAM_SID_COL)));
		facilityMemberClinic.setTeamPurpose(StringUtils.trimToEmpty(rs
				.getString(TEAM_PURPOSE_COL)));
		facilityMemberClinic.setTeamName(StringUtils.trimToEmpty(rs
				.getString(TEAM_COL)));

		facilityMemberClinic.setFacilityId(StringUtils.trimToEmpty(rs
				.getString(STA3N_COL)));

		facilityMemberClinic.setPrimaryStopCodeName(StringUtils.trimToEmpty(rs
				.getString(PRIM_STOP_CODE_NAME_COL)));
		facilityMemberClinic.setPrimaryStopCode(StringUtils.trimToEmpty(rs
				.getString(PRIM_STOP_CODE_COL)));

		facilityMemberClinic.setSecondaryStopCodeName(StringUtils.trimToEmpty(rs
				.getString(SEC_STOP_CODE_NAME_COL)));
		facilityMemberClinic.setSecondaryStopCode(StringUtils.trimToEmpty(rs
				.getString(SEC_STOP_CODE_COL)));

		facilityMemberClinic.setPhysicalLocation(StringUtils.trimToEmpty(rs
				.getString(PHYSICAL_LOC_COL)));

		facilityMemberClinic.setLocationType(StringUtils.trimToEmpty(rs
				.getString(LOCATION_TYPE_COL)));
		facilityMemberClinic.setLocationSID(StringUtils.trimToEmpty(rs
				.getString(LOCATION_SID_COL)));
		facilityMemberClinic.setLocationName(StringUtils.trimToEmpty(rs
				.getString(LOCATION_NAME_COL)));
		facilityMemberClinic.setLocationIEN(StringUtils.trimToEmpty(rs
				.getString(LOCATION_IEN_COL)));

		facilityMemberClinic.setInstitutionSID(StringUtils.trimToEmpty(rs
				.getString(INSTITUTION_SID_COL)));
		facilityMemberClinic.setInstitutionName(StringUtils.trimToEmpty(rs
				.getString(VSSC_INSTITUTION_NAME_COL)));
		facilityMemberClinic.setInstitutionIEN(StringUtils.trimToEmpty(rs
				.getString(INSTITUTION_IEN_COL)));
		facilityMemberClinic.setInstitutionCode(StringUtils.trimToEmpty(rs
				.getString(VSSC_INSTITUTION_CODE_COL)));
		facilityMemberClinic.setFriendlyLocationName(StringUtils.trimToEmpty(rs
				.getString(FRIENDLY_LOCATION_NAME_COL)));

		return (facilityMemberClinic);
	}

}
